/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

/***********************************************************************
* File name     : obsdefs.h
************************************************************************
* Written by    : Christian Zurhorst, BID R&D, 2.2.98
* Last modified : ask clearcase
************************************************************************
* File contents :
*                 own type definitions, taken out of mini_api.h 
************************************************************************
* NOTES :
************************************************************************
*/

#ifndef TRCDEFS_H_INCLUDED                               
#define TRCDEFS_H_INCLUDED

#ifndef CLI
#define CLI
#endif


/* ---------------------------------------------------------------
 * Type Definitions for Analyzer & External Trigger Functions
 * --------------------------------------------------------------- */

/* This enum represents the different status information the analyzer
   can send back to the user*/
CLI typedef enum {
  B_TRC_STAT,          /* @stat */
  B_TRC_TRIGPOINT,     /* @trig */
  B_TRC_LINESCAPT      /* @lines */
} b_tracestatustype;


/* This enum represents the different methods of the trigger settings
   of external and analyzer trigger  */
CLI typedef enum {
  B_ANA_SIMPLE,     /* @simple */
  B_ANA_COMPLEX     /* @complex */
} b_anatrigmodetype;


#define B_TRACEPROP_SIZE	 6
CLI typedef enum {
  B_TRC_HEARTBEATMODE,    /* @hbmode */
  B_TRC_HEARTBEATVALUE,   /* @hbvalue */
  B_TRC_TRIG_HISTORY,     /* @trighist */
  B_TRC_PERFANALYZER_MODE,/* @amode */
  B_TRC_PERFPATT0_MODE,   /* @pt0mode */
  B_TRC_TRIG15IO_MODE     /* @trigiomode */
} b_traceproptype;


#define B_TRACEPATTPROP_SIZE	 2
CLI typedef enum {
  B_PT_TRIGGER,         /* @trig */
  B_PT_SQ               /* @sq */
} b_tracepattproptype;


#define    B_PATTERN_SIZE    41    /* number of patterns available */
/* moved from typedefs.h for practical reasons */


CLI                             /* DEF_START ~G_PattIdent */

#define    B_PATT_TERM_0    0   /* @pt0       */
#define    B_PATT_TERM_1    1   /* @pt1       */
#define    B_PATT_TERM_2    2   /* @pt2       */
#define    B_PATT_TERM_3    3   /* @pt3       */
#define    B_PATT_TERM_4    4   /* @pt4       */
#define    B_PATT_TERM_5    5   /* @pt5       */
#define    B_PATT_TERM_6    6   /* @pt6       */
#define    B_PATT_TERM_7    7   /* @pt7       */
#define    B_PATT_TERM_8    8   /* @pt8       */
#define    B_PATT_TERM_9    9   /* @pt9       */
#define    B_PATT_TERM_10   10  /* @pt10      */
#define    B_PATT_TERM_11   11  /* @pt11      */
#define    B_PATT_TERM_12   12  /* @pt12      */
#define    B_PATT_TERM_13   13  /* @pt13      */
#define    B_PATT_TERM_14   14  /* @pt14      */
#define    B_PATT_TERM_15   15  /* @pt15      */
#define    B_PATT_TERM_16   16  /* @pt16      */
#define    B_PATT_TERM_17   17  /* @pt17      */
#define    B_PATT_TERM_18   18  /* @pt18      */
#define    B_PATT_TERM_19   19  /* @pt19      */
#define    B_PATT_TERM_20   20  /* @pt20      */
CLI                             /* DEF_END */

#define	   B_PATT_TERM_TRIG 21
#define    B_PATT_TERM_SQ   22


#if 0

#define    B_PATT_TERM_21   21  /* @pt21      */
#define    B_PATT_TERM_22   22  /* @pt22      */
#define    B_PATT_TERM_23   23  /* @pt23      */
#define    B_PATT_TERM_24   24  /* @pt24      */
#define    B_PATT_TERM_25   25  /* @pt25      */
#define    B_PATT_TERM_26   26  /* @pt26      */
#define    B_PATT_TERM_27   27  /* @pt27      */
#define    B_PATT_TERM_28   28  /* @pt28      */
#define    B_PATT_TERM_29   29  /* @pt29      */

#endif

#define    B_PATT_FAST_0    32  /* @fpt0      */
#define    B_PATT_FAST_1    33  /* @fpt1      */
#define    B_PATT_FAST_2    34  /* @fpt2      */
#define    B_PATT_FAST_3    35  /* @fpt3      */
#define    B_PATT_FAST_4    36  /* @fpt4      */
#define    B_PATT_FAST_5    37  /* @fpt5      */
#define    B_PATT_FAST_6    38  /* @fpt6      */
#define    B_PATT_FAST_7    39  /* @fpt7      */

#define    B_PATT_TERM_TRAN 40


#endif


